package com.example.demo;

import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.kafka.annotation.KafkaListener;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.kafka.retrytopic.RetryTopicConfiguration;
import org.springframework.kafka.retrytopic.RetryTopicConfigurationBuilder;

@SpringBootApplication
public class DemoApplication {

  public static void main(String[] args) {
    SpringApplication.run(DemoApplication.class, args);
  }

  @KafkaListener(topics = "${kafka.topic}", groupId = "id")
  public void listen(String message) {

  }

  @Bean
  public RetryTopicConfiguration retryTopicConfiguration(KafkaTemplate<String, String> template) {
    return RetryTopicConfigurationBuilder.newInstance()
        .includeTopic("topic")
        .create(template);
  }
}
